<?php
namespace PEAR2;

class Autoload {
    public static function initialize($baseDir = null) {
        spl_autoload_register(function ($class) use ($baseDir) {
            if (strpos($class, 'PEAR2\\Net\\RouterOS') === 0) {
                $path = str_replace('\\', '/', $class) . '.php';
                if ($baseDir !== null) {
                    $path = rtrim($baseDir, '/') . '/' . $path;
                }
                if (file_exists($path)) {
                    require_once $path;
                }
            }
        });
    }
}